{********************************************
; File: Locator.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT LOCATOR;
INTERFACE
USES TYPES;
CONST

{ Error Codes }
toolNotFoundErr = $0001;
funcNotFoundErr = $0002;
sysStrtMtErr = $0100;  { can't mount system startup volume }
tlBadRecFlag = $0103;  { StartStop record invalid }
tlCantLoad = $0104;  { A tool cannot be loaded }
toolVersionErr = $0110;
messNotFoundErr = $0111;
messageOvfl = $0112;  { No message numbers available }
nameTooLong = $0113;  { Message name too long }

{ MessageCenter Codes }
fileInfoType = $0001;  { Message type parameter }
addMessage = $0001;  { action parameter }
getMessage = $0002;  { action parameter }
deleteMessage = $0003;  { action parameter }

{ TLMountVolume Codes }
mvReturn = $0001;  { like ok for dialogs }
mvEscape = $0002;  { like cancel for dialogs }

{ Tool Set Spec Codes }
sysTool = $0000;
userTool = $8000;
{$IFC UNDEFINED theToolsLength }  { ToolTable - default number of ToolSpecs }
theToolsLength = $0010;
{$SETC theToolsLength := 0}
{$ENDC}

TYPE
MessageRecHndl = ^MessageRecPtr;
MessageRecPtr = ^MessageRec;
MessageRec = RECORD
    messageNext : MessageRecHndl;
    messageType : Integer;
    messageData : Integer;
    fileNames : PACKED ARRAY[1..1] OF Str255;
END;
ToolSpec = RECORD
    toolNumber : Integer;
    minVersion : Integer;
END;
ToolTablePtr = ^ToolTable;
ToolTable = RECORD
    toolCount : Integer;
    theTools : ARRAY[1..theToolsLength] OF ToolSpec;
END;
StartStopRecordPtr = ^StartStopRecord;
StartStopRecord = RECORD
    flags : Integer;
    videoMode : Integer;
    resFileID : Integer;
    dPageHandle : Handle;
    numTools : Integer;
    theTools : ARRAY[1..theToolsLength] OF ToolSpec;
END;
ResponseRecord = Longint ;
FUNCTION GetFuncPtr ( userOrSystem:Integer; funcTSNum:Integer) : Ptr ;
FUNCTION GetTSPtr ( userOrSystem:Integer; tSNum:Integer) : Ptr ;
FUNCTION GetWAP ( userOrSystem:Integer; tSNum:Integer) : Ptr ;
PROCEDURE LoadOneTool ( toolNumber:Integer; minVersion:Integer)  ;
PROCEDURE LoadTools ( theToolTablePtr:ToolTablePtr)  ;
FUNCTION MessageByName ( createItFlag:Boolean; recordPtr:Ptr) : ResponseRecord ;
PROCEDURE MessageCenter ( action:Integer; messagetype:Integer; messageHandle:MessageRecHndl)  ;
PROCEDURE RestoreTextState ( stateHandle:Handle)  ;
FUNCTION SaveTextState  : Handle ;
PROCEDURE SetDefaultTPT   ;
PROCEDURE SetTSPtr ( userOrSystem:Integer; tsNum:Integer; fptablePtr:FPTPtr)  ;
PROCEDURE SetWAP ( userOrSystem:Integer; tSNum:Integer; waptPtr:Ptr)  ;
PROCEDURE ShutDownTools ( startStopDesc:RefDescriptor; startStopRef:Ref)  ;
FUNCTION StartUpTools ( userID:Integer; startStopRefDesc:RefDescriptor; startStopRef:Ref) : Ref ;
PROCEDURE TLBootInit   ;
FUNCTION TLMountVolume ( whereX:Integer; whereY:Integer; line1:Str255; line2:Str255; but1:Str255; but2:Str255) : Integer ;
PROCEDURE TLReset   ;
PROCEDURE TLShutDown   ;
PROCEDURE TLStartUp   ;
FUNCTION TLStatus  : Boolean ;
FUNCTION TLTextMountVolume ( line1:Str255; line2:Str255; but1:Str255; but2:Str255) : Integer ;
FUNCTION TLVersion  : Integer ;
PROCEDURE UnloadOneTool ( toolNumber:Integer)  ;
IMPLEMENTATION
END.
